/*
 * Decompiled with CFR 0.152.
 */
package com.worldswanderer.acid.setup;

import com.worldswanderer.acid.setup.ModFluids;
import com.worldswanderer.acid.setup.ModItems;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HugeMushroomBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.MushroomBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class ModBlocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"acid");
    public static final RegistryObject<Block> ACID_MUSHROOM_BLOCK = BLOCKS.register("acid_mushroom_block", () -> new HugeMushroomBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50181_)));
    public static final RegistryObject<Block> ACID_MUSHROOM_STEM = BLOCKS.register("acid_mushroom_stem", () -> new HugeMushroomBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50182_)));
    public static final RegistryObject<Block> SMALL_ACID_MUSHROOM = BLOCKS.register("small_acid_mushroom", () -> new CustomMushroomBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50073_).m_60977_()));
    public static final RegistryObject<LiquidBlock> WEAK_ACID = BLOCKS.register("weak_acid", () -> new WeakAcidBlock(() -> (FlowingFluid)ModFluids.WEAK_ACID.get(), BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_49990_)));
    public static final RegistryObject<LiquidBlock> ACID = BLOCKS.register("acid", () -> new AcidBlock(() -> (FlowingFluid)ModFluids.ACID.get(), BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_49990_)));
    public static final RegistryObject<SnowLayerBlock> ACIDIC_SEDIMENT = BLOCKS.register("acidic_sediment", () -> new AcidResidueBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50125_)));

    public static class AcidResidueBlock
    extends SnowLayerBlock {
        public AcidResidueBlock(BlockBehaviour.Properties properties) {
            super(properties);
        }

        public boolean canHarvestBlock(BlockState state, BlockGetter world, BlockPos pos, Player player) {
            return true;
        }

        public List<ItemStack> m_49635_(BlockState state, LootParams.Builder builder) {
            int layers = (Integer)state.m_61143_((Property)f_56581_);
            ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
            drops.add(new ItemStack((ItemLike)ModItems.ACID_CONCENTRATE.get(), layers));
            return drops;
        }
    }

    public static class AcidBlock
    extends LiquidBlock {
        public AcidBlock(Supplier<? extends FlowingFluid> supplier, BlockBehaviour.Properties properties) {
            super(supplier, properties);
        }

        public RenderShape m_7514_(BlockState state) {
            return RenderShape.MODEL;
        }

        public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
            super.m_7892_(state, level, pos, entity);
            if (!level.f_46443_ && entity instanceof LivingEntity) {
                LivingEntity le = (LivingEntity)entity;
                le.m_6469_(level.m_269111_().m_269425_(), 1.0f);
            }
        }
    }

    public static class WeakAcidBlock
    extends LiquidBlock {
        public WeakAcidBlock(Supplier<? extends FlowingFluid> supplier, BlockBehaviour.Properties properties) {
            super(supplier, properties);
        }

        public RenderShape m_7514_(BlockState state) {
            return RenderShape.MODEL;
        }

        public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
            super.m_6861_(state, level, pos, block, fromPos, isMoving);
            for (Direction d : Direction.values()) {
                BlockPos neighborPos = pos.m_121945_(d);
                BlockState neighborState = level.m_8055_(neighborPos);
                if (!neighborState.m_60713_(Blocks.f_50056_)) continue;
                level.m_7731_(neighborPos, Blocks.f_50057_.m_49966_(), 3);
                level.m_46796_(2001, neighborPos, Block.m_49956_((BlockState)Blocks.f_50056_.m_49966_()));
                for (Direction dd : Direction.values()) {
                    BlockPos maybeacidNeighborPos = neighborPos.m_121945_(dd);
                    BlockState maybeacidNeighborState = level.m_8055_(maybeacidNeighborPos);
                    if (!maybeacidNeighborState.m_60713_((Block)WEAK_ACID.get()) || !maybeacidNeighborState.m_60819_().m_76170_()) continue;
                    level.m_7731_(maybeacidNeighborPos, (BlockState)((SnowLayerBlock)ACIDIC_SEDIMENT.get()).m_49966_().m_61124_((Property)SnowLayerBlock.f_56581_, (Comparable)Integer.valueOf(1)), 3);
                }
                return;
            }
        }
    }

    public static class CustomMushroomBlock
    extends MushroomBlock {
        protected String dimensionID = "blue_skies:everdawn";
        protected int maxHeight = 7;
        protected int minHeight = 4;
        protected int maxRadius = 3;

        public CustomMushroomBlock(BlockBehaviour.Properties properties) {
            super(properties, null);
        }

        public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
            Level l;
            if (level instanceof Level && !(l = (Level)level).m_46472_().m_135782_().toString().equals(this.dimensionID)) {
                return false;
            }
            BlockPos groundPos = pos.m_7495_();
            BlockState groundState = level.m_8055_(groundPos);
            if (groundState.m_204336_(BlockTags.f_13057_)) {
                return true;
            }
            return level.m_46803_(pos) < 13 && groundState.canSustainPlant((BlockGetter)level, groundPos, Direction.UP, (IPlantable)this);
        }

        public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
            if (!level.m_46472_().m_135782_().toString().equals(this.dimensionID)) {
                level.m_46961_(pos, false);
                return;
            }
            super.m_213898_(state, level, pos, random);
        }

        public boolean m_221773_(ServerLevel level, BlockPos pos, BlockState state, RandomSource random) {
            level.m_7471_(pos, false);
            int height = this.minHeight + random.m_188503_(this.maxHeight - this.minHeight + 1);
            for (int i = 0; i < height; ++i) {
                if (this.safeSetBlock(level, pos.m_6630_(i), (BlockState)((BlockState)((Block)ACID_MUSHROOM_STEM.get()).m_49966_().m_61124_((Property)HugeMushroomBlock.f_54131_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)HugeMushroomBlock.f_54132_, (Comparable)Boolean.valueOf(false)))) continue;
                return true;
            }
            BlockPos top = pos.m_6630_(height);
            if (!this.safeSetBlock(level, top, (BlockState)((Block)ACID_MUSHROOM_BLOCK.get()).m_49966_().m_61124_((Property)HugeMushroomBlock.f_54132_, (Comparable)Boolean.valueOf(false)))) {
                return true;
            }
            int radius = 1 + random.m_188503_(this.maxRadius - 1);
            for (int x = -radius; x <= radius; ++x) {
                for (int z = -radius; z <= radius; ++z) {
                    if (x == 0 && z == 0 || random.m_188500_() < 0.15) continue;
                    BlockPos leafPos = top.m_7918_(x, 0, z);
                    BlockState mushroomState = ((Block)ACID_MUSHROOM_BLOCK.get()).m_49966_();
                    this.safeSetBlock(level, leafPos, mushroomState);
                }
            }
            return true;
        }

        private boolean safeSetBlock(ServerLevel level, BlockPos pos, BlockState newState) {
            boolean isReplaceable;
            BlockState oldState = level.m_8055_(pos);
            boolean bl = isReplaceable = oldState.m_60795_() || oldState.m_204336_(BlockTags.f_13035_) || oldState.m_247087_();
            if (isReplaceable && oldState.m_60800_((BlockGetter)level, pos) != -1.0f) {
                level.m_7731_(pos, newState, 3);
                return true;
            }
            return false;
        }
    }
}

